USE [SUPERMERCADO]
-- ================================================
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- AUTOR: ERICK MARTINEZ
-- FECHA DE CREACION: 10/06/2015
-- DESCRIPCION: CANTIDAD DE DIAS QUE HACEN FALTA PARA QUE CADUQUE UN PRODUCTO
-- =============================================
CREATE FUNCTION [dbo].[DIAS_CADUCIDAD_PRODUCTO]
(
	@ID_PRODUCTO INT
)
RETURNS INT
AS
BEGIN

	DECLARE @CADUCIDAD_DIAS INT
	DECLARE @FECHA_ACTUAL DATE = CAST (GETDATE() AS DATE )

	
	SELECT 
		@CADUCIDAD_DIAS = 
			DATEDIFF(DAY,@FECHA_ACTUAL,[SUPERMERCADO].[dbo].[PRODUCTO].[FECHA_VENCIMIENTO_PRODUCTO])

	FROM 
		[SUPERMERCADO].[dbo].[PRODUCTO]

	WHERE 
		@ID_PRODUCTO = [SUPERMERCADO].[dbo].[PRODUCTO].[ID_PRODUCTO]


	--ES PARA QUE NO SALGAN VALOR NEGATIVOS
	IF(@CADUCIDAD_DIAS < 0)
	BEGIN 
		SET @CADUCIDAD_DIAS = 0
	END


	RETURN @CADUCIDAD_DIAS

END
GO

